*** rt-contrib.do
*** v1.2
***
*** Creates u-contrib forecasts from real-time data. Outputs ur_s_NNN and ur_f_NNN,
***   where NNN is the date of the first forecast for the UR (i.e., the unemployment 
***   rate is known through month NNN-1). NNN is the Stata date code for months, 
***   where 192 = 1976m1. ur_s indicates that s is forecast and f is held constant.
***
clear all
set more off
set type double

global path = "$HOME/research/ssur"

use $path/data/rtdata/rt-E.dta, clear
merge 1:1 mdate using $path/data/rtdata/rt-U.dta, nogen
merge 1:1 mdate using $path/data/rtdata/rt-U_s.dta, nogen

keep if mdate>=tm(1951m1)

cap erase fhist-contrib.dta

unab rellist: U_s_*
local rdatelist: subinstr local rellist "U_s_" "", all
local i = 1
preserve
foreach rdate of local rdatelist {
  if `rdate'>=106 {
    noi disp "$S_DATE $S_TIME " %tm `rdate'
    restore, preserve
    gen E = E_`rdate'
    gen U = U_`rdate'
    gen U_s = U_s_`rdate'
    sum mdate if E_`rdate'!=.
    outsheet mdate E U U_s if mdate<=r(max) using foo.csv, comma replace nonames
    !echo "E U U_S" > input.csv
    !cat foo.csv >> input.csv
    !rats rt-contrib.prg rt-contrib-`rdate'.out
    insheet using output.csv, comma clear
    gen int mdate=tm(1951m1)+_n-1
    drop v1
    order mdate
    foreach con in s f {
      rename ur_`con' ur_`con'_`rdate'
      rename s_`con' s_`con'_`rdate'
      rename f_`con' f_`con'_`rdate'
    }
    if `i'>1 {
      merge 1:1 mdate using fhist-contrib.dta, nogen
    }
    compress
    save fhist-contrib.dta, replace
    local i=`++i'
  }
}

use fhist-contrib.dta, replace
drop s* f*
reshape long ur_s_ ur_f_, i(mdate) j(fcdate)
rename ur_s_ ur_s
rename ur_f_ ur_f
order fcdate mdate
sort fcdate mdate
format %tm *date
drop if ur_s==.
compress
save rt-contrib.dta, replace

* clean up
!pigz -9f fhist-contrib.dta
erase foo.csv
erase input.csv
erase output.csv
!tar czf rt-contrib-logs.tar.gz rt-contrib-*.out
!rm rt-contrib-*.out
*/

if "$S_CONSOLE"=="console" exit, STATA clear
